package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.ImageObserver;
import java.util.ArrayList;

import javax.sound.sampled.Clip;

public class RadioScreenPaletteObject extends ScreenPaletteObject {

	private CustomImageDataII radioImage;
	private String caption;
	private Color captionColor;
	private String waveFile;
	
	private ArrayList<RadioScreenObject> createdObjects;
	
	private Clip clip;
	
	@Override
	public ScreenObject create(int objX, int objY, ImageObserver io) {
		
		IntRect rect = new IntRect(objX - radioImage.getDesiredWidth() / 2, 
				objY - radioImage.getDesiredHeight() / 2, 
				radioImage.getDesiredWidth(), 
				radioImage.getDesiredHeight());
		
		
		RadioScreenObject returnValue = new RadioScreenObject(io, rect, this);
		
		createdObjects.add(returnValue);
		
		return returnValue;
	}

	@Override
	public void delete(ScreenObject so) {
		
		
		for(int i = 0; i < createdObjects.size(); i++) {
			if(createdObjects.get(i).equals(so)) {
				createdObjects.remove(i);
				i = createdObjects.size();
			}
		}
		
		
	}

	@Override
	public void draw(Graphics g) {
		
		Color origCol = g.getColor();
		g.setColor(captionColor);
		
		Font origFont = g.getFont();
		Font newFont = new Font(origFont.getName(), Font.BOLD, 18);
		g.setFont(newFont);
		
		if(radioImage != null)
			radioImage.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		if(caption != null && captionColor != null)
		g.drawString(caption, clickRect.getMinX() + 4, clickRect.getMaxY() - 10);
		

		if(isSelected) {
			g.setColor(new Color(255, 200, 0));
		} else {
			g.setColor(new Color(100, 100, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		
		g.setFont(origFont);
		g.setColor(origCol);
		
	}
	
	
	public RadioScreenPaletteObject(String theFileName, String theCaption, Color theCaptionColor, int theDistanceToBorder, int theBorderWidth, IntRect theClickRect, Clip theClip, ImageObserver io) {

		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;
		
		createdObjects = new ArrayList<RadioScreenObject>();
		radioImage = RadioScreenObject.getRadioImage(io);
		
		waveFile = theFileName;
		caption = theCaption;
		captionColor = theCaptionColor;
		
		clickRect = theClickRect;
		clip = theClip;
		
	}

	public String getCaption() {
		return caption;
	}

	public Color getCaptionColor() {
		return captionColor;
	}

	public String getWaveFile() {
		return waveFile;
	}

	public Clip getClip() {
		return clip;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public void setCaptionColor(Color captionColor) {
		this.captionColor = captionColor;
	}

	public void setWaveFile(String waveFile) {
		this.waveFile = waveFile;
	}

	public void setClip(Clip clip) {
		this.clip = clip;
	}
	
	
	

}
